/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.init.ValhelsiaLootConditions;

public class MatchBlockCondition
implements ILootCondition {
    @Nullable
    private final List<Block> blocks;
    @Nullable
    private final ITag.INamedTag<Block> tag;
    @Nullable
    private final StatePropertiesPredicate properties;

    public MatchBlockCondition(@Nullable List<Block> blocks, @Nullable ITag.INamedTag<Block> tag, @Nullable StatePropertiesPredicate properties) {
        this.blocks = blocks;
        this.tag = tag;
        this.properties = properties;
    }

    public static ILootCondition.IBuilder builder(List<Block> blocks) {
        return () -> new MatchBlockCondition(blocks, null, null);
    }

    public static ILootCondition.IBuilder builder(ITag.INamedTag<Block> tag) {
        return () -> new MatchBlockCondition(null, tag, null);
    }

    public static ILootCondition.IBuilder builder(List<Block> blocks, ITag.INamedTag<Block> tag) {
        return () -> new MatchBlockCondition(blocks, tag, null);
    }

    public static ILootCondition.IBuilder builder(List<Block> blocks, ITag.INamedTag<Block> tag, StatePropertiesPredicate properties) {
        return () -> new MatchBlockCondition(blocks, tag, properties);
    }

    @Nonnull
    public LootConditionType func_230419_b_() {
        return ValhelsiaLootConditions.MATCH_BLOCK;
    }

    @Nonnull
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216287_g);
    }

    public boolean test(LootContext lootContext) {
        BlockState state = (BlockState)lootContext.func_216031_c(LootParameters.field_216287_g);
        if (state == null) {
            return false;
        }
        boolean flag = false;
        if (this.tag != null) {
            flag = this.tag.func_230235_a_((Object)state.func_177230_c());
        }
        if (this.blocks != null && !flag) {
            flag = this.blocks.contains(state.func_177230_c());
        }
        if (this.properties != null) {
            flag = this.properties.func_227181_a_(state);
        }
        return flag;
    }

    public static class Serializer
    implements ILootSerializer<MatchBlockCondition> {
        public void serialize(@Nonnull JsonObject jsonObject, MatchBlockCondition instance, @Nonnull JsonSerializationContext context) {
            if (instance.tag != null) {
                jsonObject.addProperty("tag", instance.tag.func_230234_a_().toString());
            }
            if (instance.properties != null) {
                jsonObject.add("properties", instance.properties.func_227180_a_());
            }
        }

        @Nonnull
        public MatchBlockCondition deserialize(JsonObject jsonObject, @Nonnull JsonDeserializationContext context) {
            if (jsonObject.has("tag")) {
                ResourceLocation tag = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
                return new MatchBlockCondition(null, (ITag.INamedTag<Block>)BlockTags.createOptional((ResourceLocation)tag), this.deserializeProperties(jsonObject));
            }
            if (jsonObject.has("blocks")) {
                ArrayList<Block> blocks = new ArrayList<Block>();
                for (JsonElement e : JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"blocks")) {
                    ResourceLocation blockName = new ResourceLocation(e.getAsString());
                    blocks.add((Block)ForgeRegistries.BLOCKS.getValue(blockName));
                }
                return new MatchBlockCondition(blocks, null, this.deserializeProperties(jsonObject));
            }
            if (jsonObject.has("block")) {
                ResourceLocation block = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"block"));
                return new MatchBlockCondition(Collections.singletonList(ForgeRegistries.BLOCKS.getValue(block)), null, this.deserializeProperties(jsonObject));
            }
            throw new RuntimeException("match_block must have one of 'tag', 'block' or 'blocks' key");
        }

        private StatePropertiesPredicate deserializeProperties(JsonObject jsonObject) {
            if (jsonObject.has("properties")) {
                return StatePropertiesPredicate.func_227186_a_((JsonElement)jsonObject.get("properties"));
            }
            return null;
        }
    }
}

